<?php 
/*	
*	Super Object File
*	---------------------------------------------------------------------
*	This file Contain all the custom Built in function 
*	Developer Note: do not update this file.
*	---------------------------------------------------------------------
*/
	/* Print Content Item */
	function tabligh_print_default_content_item(){
		
		while ( have_posts() ) : the_post(); ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<?php
					the_content();
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'tabligh' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					) );
					/* Comments list Template */ if ( comments_open() || get_comments_number() ) : comments_template(); endif;
					if (comments_open()){ ?> 
					<div class = "cnt-frm cmt-frm">
						<?php /* comment Form */
						$post_commenter = wp_get_current_commenter();
						$req = get_option( 'require_name_email' );
						$aria_req = ( $req ? " aria-required='true'" : '' );
						if(function_exists('tabligh_comment_form_temp')){
							echo tabligh_comment_form_temp($post_commenter, $req, $aria_req );
						}
						?>
					</div>
					<?php } 

					edit_post_link( esc_html__( 'Edit', 'tabligh' ), '<span class="edit-link">', '</span>' );
				?>
		</div><!-- #post-## -->
		
		<?php	
		endwhile;
	}
	

	function tabligh_show_sidebar($sidebar_name, $right_sidebar,$left_sidebar,$value_right,$value_left){ ?>
		<div class="row-fluid sidebar-panel-box">
			<ul class="recipe_class span6">
				<li class="panel-radioimage">
					<div class="panel-title sideba-title">
						<h3><?php esc_html_e('Select Sidebar Position', 'tabligh'); ?></h3>
					</div>
					<div class="clear"></div>
					<?php /* Sidebar Images */
					$options = array(
						'1'=>array('value'=>'left-sidebar','image'=>'/framework/images/left-sidebar.jpg'),
						'2'=>array('value'=>'right-sidebar','image'=>'/framework/images/right-sidebar.jpg'),
						'3'=>array('value'=>'no-sidebar','image'=>'/framework/images/no-sidebar.jpg')
					);
					foreach( $options as $option ){ ?>
						<div class='radio-image-wrapper'>
							<span class="head-sec-sidebar"><?php echo str_replace('-',' ',$option['value']); ?></span>
							<label for="<?php echo esc_attr($option['value']); ?>">
								<img src=<?php echo get_template_directory_uri().$option['image']?> class="<?php echo esc_attr($sidebar_name);?>" alt="<?php echo esc_attr($sidebar_name);?>">
								<div id="check-list" <?php 
									if($sidebar_name == $option['value']){
										echo 'class="check-list"';
									}
								?>>
							</div>                                
							</label>
							<input type="radio" name="sidebars" value="<?php echo esc_attr($option['value']); ?>" <?php 
									if($sidebar_name == $option['value']){
										echo 'checked';
									}
							?> id="<?php echo esc_attr($option['value']); ?>" class="<?php echo esc_attr($sidebar_name);?>"
							>                            
						</div>
					<?php } ?>
				</li>
			</ul>
			<ul class="tabligh_left_sidebar recipe_class span3">
				<li class="panel-input">	
					<div class="panel-title">
						<h3><?php esc_html_e('Left Sidebar', 'tabligh'); ?></h3>
					</div>
					<div class="combobox">
						<select name="<?php echo esc_attr($left_sidebar);?>" id="tabligh_sidebar_dropdown_left">				
							<?php
								if (function_exists('register_sidebar')){	
									/* Variable Redux Options */
									global $tabligh_options;
									/* Fetch Value From Theme Options Panel */
									$unlimited_sidebars_var =  $tabligh_options['multi-text'];

									if(is_array($unlimited_sidebars_var)){
										/* Loop For all added sidebars */
										foreach($unlimited_sidebars_var as $single_sidebars_var){
										
											if(!empty($single_sidebars_var)){ ?>
												<option <?php if($value_left == $single_sidebars_var){ echo 'selected';}?> value="<?php echo esc_attr($single_sidebars_var); ?>"><?php echo esc_attr($single_sidebars_var); ?></option>
											<?php
											}
										} /* end foreach */
									} /* endif */
								}/* endif */
							?>
						</select>
					</div>
					<p><?php esc_html_e('Select Sidebar if Created In Theme Options > Sidebars to apply this post.', 'tabligh'); ?></p>
				</li>
			</ul>
			<ul class="tabligh_right_sidebar recipe_class span3">
				<li class="panel-input">	
					<div class="panel-title">
						<h3><?php esc_html_e('Right Sidebar', 'tabligh'); ?></h3>
					</div>
					<div class="combobox">
						<select name="<?php echo esc_attr($right_sidebar);?>" id="tabligh_sidebar_dropdown_right">		
							<?php
								if (function_exists('register_sidebar')){	
									/* Variable Redux Options */
									global $tabligh_options;
									/* Fetch Value From Theme Options Panel */
									$unlimited_sidebars_var =  $tabligh_options['multi-text'];

									if(is_array($unlimited_sidebars_var)){
										/* Loop For all added sidebars */
										foreach($unlimited_sidebars_var as $single_sidebars_var){
										
											if(!empty($single_sidebars_var)){ ?>

												<option <?php if($value_right == $single_sidebars_var){ echo 'selected';}?> value="<?php echo esc_attr($single_sidebars_var); ?>"><?php echo esc_attr($single_sidebars_var); ?></option>
												
												<?php
											}
										} /* end foreach */
									} /* endif */
								}/* endif */
							?>	
						</select>
					</div>
					<p><?php esc_html_e('Select Sidebar if Created In Theme Options > Sidebars to apply this post.', 'tabligh'); ?></p>
				</li>	
			</ul>
		</div>
		<hr></hr>
		<div class="clear"></div>
<?php } 
	
	
	
	/* Get Popular posts */
	function tabligh_popular_set_post_views($postID) {
		$count_key = 'popular_post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			$count = 0;
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
		}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
		}
	}
	
	function tabligh_popular_track_post_views ($post_id) {
		if ( !is_single() ) return;
		if ( empty ( $post_id) ) {
			global $post;
			$post_id = $post->ID;    
		}
		tabligh_popular_set_post_views($post_id);
	}
	add_action( 'wp_head', 'tabligh_popular_track_post_views');


	function tabligh_wpb_get_post_views($postID){
		$count_key = 'popular_post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
			return "0 View";
		}
		return $count.' Views';
	}
	
	
	
	/* Sidebar function */
	function tabligh_sidebar_func($sidebarr){
		if ($sidebarr == "left-sidebar" || $sidebarr == "right-sidebar") {
            $sidebar_class[] = 'col-md-3 content_sidebar sidebar';
			$sidebar_class[1] = 'col-md-9';
        }else if ($sidebarr == "both-sidebar") {
            $sidebar_class[] = "col-md-3 content_sidebar sidebar";
			$sidebar_class[1] = 'col-md-6';
        }else if($sidebarr == "both-sidebar-left") {
		    $sidebar_class[] = "col-md-3 content_sidebar sidebar";
			$sidebar_class[1] = 'col-md-6';
		}else if($sidebarr == "both-sidebar-right") {
		    $sidebar_class[] = "col-md-3 content_sidebar sidebar";
			$sidebar_class[1] = 'col-md-6';
		}else{
			$sidebar_class[1] = 'col-md-12';
		}
		return $sidebar_class;
	}
	
	
	/* Get Post Views */
	function tabligh_getPostViews($postID){
		$count_key = 'post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
			return esc_html__("0 View", "tabligh");
		}
		return $count.esc_html__(' Views', 'tabligh');
	}
	
	/* Set Post Views */
	function tabligh_setPostViews($postID) {
		$count_key = 'post_views_count';
		$count = get_post_meta($postID, $count_key, true);
		if($count==''){
			$count = 0;
			delete_post_meta($postID, $count_key);
			add_post_meta($postID, $count_key, '0');
		}else{
			$count++;
			update_post_meta($postID, $count_key, $count);
		}
	}
	
	function tabligh_booking_form_event_manager() {

		global $EM_Notices,$EM_Event;
		/* count tickets and available tickets */
		$tickets_count = count($EM_Event->get_bookings()->get_tickets()->tickets);
		$available_tickets_count = count($EM_Event->get_bookings()->get_available_tickets());
		/* decide whether user can book, event is open for bookings etc. */
		$can_book = is_user_logged_in() || (get_option('dbem_bookings_anonymous') && !is_user_logged_in());
		$is_open = $EM_Event->get_bookings()->is_open(); 
		$show_tickets = true;
		/* if user is logged out, check for member tickets that might be available, since we should ask them to log in instead of saying 'bookings closed' */
		if( !$is_open && !is_user_logged_in() && $EM_Event->get_bookings()->is_open(true) ){
			$is_open = true;
			$can_book = false;
			$show_tickets = false;
		}
		?>
		<div id="em-booking" class="em-booking <?php if( get_option('dbem_css_rsvp') ) echo 'css-booking'; ?>">
			<?php 
				/* We are firstly checking if the user has already booked a ticket at this event, if so offer a link to view their bookings.*/
				$EM_Booking = $EM_Event->get_bookings()->has_booking();
			?>
			<?php 
			if(!empty($EM_Event->bookings)){
				if( is_object($EM_Booking) && !get_option('dbem_bookings_double') ): ?>
					<p>
						<?php echo get_option('dbem_bookings_form_msg_attending'); ?>
						<a href="<?php echo esc_url(em_get_my_bookings_url()); ?>"><?php echo get_option('dbem_bookings_form_msg_bookings_link'); ?></a>
					</p>
				<?php elseif( !$EM_Event->event_rsvp ): ?>
					<p><?php echo get_option('dbem_bookings_form_msg_disabled'); ?></p>
				<?php elseif( $EM_Event->get_bookings()->get_available_spaces() <= 0 ): ?>
					<p><?php echo get_option('dbem_bookings_form_msg_full'); ?></p>
				<?php elseif( !$is_open ):?>
					<p><?php echo get_option('dbem_bookings_form_msg_closed');  ?></p>
				<?php else: ?>
					<?php echo html_entity_decode($EM_Notices); ?>
					<?php if( $tickets_count > 0) : ?>
						<?php /* Tickets exist, so we show a booking form.*/ ?>
						<form class="em-booking-form" name='booking-form' method='post' action='<?php echo apply_filters('em_booking_form_action_url',''); ?>#em-booking'>
							<input type='hidden' name='action' value='booking_add'/>
							<input type='hidden' name='event_id' value='<?php echo esc_attr($EM_Event->event_id); ?>'/>
							<input type='hidden' name='_wpnonce' value='<?php echo wp_create_nonce('booking_add'); ?>'/>
							<?php 
								/* Tickets Form */
								if( $show_tickets && ($can_book || get_option('dbem_bookings_tickets_show_loggedout')) && ($tickets_count > 1 || get_option('dbem_bookings_tickets_single_form')) ){ /* show if more than 1 ticket, or if in forced ticket list view mode */
									do_action('em_booking_form_before_tickets', $EM_Event); //do not delete
									/*Show multiple tickets form to user, or single ticket list if settings enable this*/
									/*If logged out, can be allowed to see this in settings witout the register form */
									em_locate_template('forms/bookingform/tickets-list.php',true, array('EM_Event'=>$EM_Event));
									do_action('em_booking_form_after_tickets', $EM_Event); 
									$show_tickets = false;
								}
							?>
							<?php if( $can_book ): ?>
								<div class='em-booking-form-details'>
									<?php 
										if( $show_tickets && $available_tickets_count == 1 && !get_option('dbem_bookings_tickets_single_form') ){
											do_action('em_booking_form_before_tickets', $EM_Event); 
											/* show single ticket form, only necessary to show to users able to book (or guests if enabled) */
											$EM_Ticket = $EM_Event->get_bookings()->get_available_tickets()->get_first();
											em_locate_template('forms/bookingform/ticket-single.php',true, array('EM_Event'=>$EM_Event, 'EM_Ticket'=>$EM_Ticket));
											do_action('em_booking_form_after_tickets', $EM_Event);
										} 
									?>
									<?php
										do_action('em_booking_form_before_user_details', $EM_Event);
										if( has_action('em_booking_form_custom') ){ 
											/* Pro Custom Booking Form. You can create your own custom form by hooking into this action and setting the option above to true */
											do_action('em_booking_form_custom', $EM_Event); 
										}else{
											/* If you just want to modify booking form fields, you could do so here */
											em_locate_template('forms/bookingform/booking-fields.php',true, array('EM_Event'=>$EM_Event));
										}
										do_action('em_booking_form_after_user_details', $EM_Event);
									?>
									<?php do_action('em_booking_form_footer', $EM_Event);  ?>
									<div class="em-booking-buttons">
										<?php if( preg_match('/https?:\/\//',get_option('dbem_bookings_submit_button')) ): /*Settings have an image url (we assume). Use it here as the button.*/?>
										<input type="image" src="<?php echo get_option('dbem_bookings_submit_button'); ?>" class="em-booking-submit" id="em-booking-submit" />
										<?php else: /*Display normal submit button */?>
										<input type="submit" class="em-booking-submit" id="em-booking-submit" value="<?php echo esc_attr(get_option('dbem_bookings_submit_button')); ?>" />
										<?php endif; ?>
									</div>
									<?php do_action('em_booking_form_footer_after_buttons', $EM_Event);?>
								</div>
							<?php else: ?>
								<p class="em-booking-form-details"><?php echo get_option('dbem_booking_feedback_log_in'); ?></p>
							<?php endif; ?>
						</form>	
						<div class = "event_login_form">
							<?php 
							if( !is_user_logged_in() && get_option('dbem_bookings_login_form') ){
								/*User is not logged in, show login form (enabled on settings page)*/
								em_locate_template('forms/bookingform/login.php',true, array('EM_Event'=>$EM_Event));
							}
							?>
						</div>
						<br class="clear" />  
					<?php endif; ?>
				<?php endif;
			}
			?>
		</div>
	<?php }

	/* Remove issues with prefetching adding extra views */
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
	
	/* return the array of category */
	function tabligh_get_category_list_array( $category_name, $parent='' ){
		
		if( empty($parent) ){ 
			$category_list = array();
			$get_category = get_categories( array( 'taxonomy' => $category_name	));
			if($get_category <> ''){
				foreach( $get_category as $category ){
					$category_list[] = $category;
				}
			}
				
			return $category_list;
			
		}else{
			
			$parent_id = get_term_by('name', $parent, $category_name);
			$get_category = get_categories( array( 'taxonomy' => $category_name, 'child_of' => $parent_id->term_id	));
			$category_list = array( '0' => $parent );
			if($get_category <> ''){
				foreach( $get_category as $category ){
					$category_list[] = $category;
				}
			}
				
			return $category_list;		
		
		}
	}
			 

	/*  Adding custom Post Type in Search Results */
	function tabligh_search_filter($query) {
	 
		if ( !is_admin() && $query->is_main_query() ) {
			
			if ($query->is_search) {
			 
			 $query->set('post_type', array( 'post', 'team', 'courses', 'sermons' , 'charitable', 'event', 'product', 'services') );
			
			}
		  
		}
	
	}
	
	add_action('pre_get_posts','tabligh_search_filter');
		

		/* Get Attachment Meta For Visual Composer Gallery */
		function tabligh_wp_get_attachment( $attachment_id ) {

			$attachment = get_post( $attachment_id );
			
			return array(
				'alt' => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
				'caption' => $attachment->post_excerpt,
				'description' => $attachment->post_content,
				'href' => get_permalink( $attachment->ID ),
				'src' => $attachment->guid,
				'title' => $attachment->post_title,
				'date' => $attachment->post_date_gmt
			);
		}
		
		/* Media Uploader */
		function tabligh_load_wp_media_files() {
			wp_enqueue_media();
		}
		
		add_action( 'admin_enqueue_scripts', 'tabligh_load_wp_media_files' );
		add_filter('deprecated_constructor_trigger_error', '__return_false');
		
		
		/* Move Comment To Above */
		function tabligh_move_comment_field_to_bottom( $fields ) {
			
			$comment_field = $fields['comment'];
			
			unset( $fields['comment'] );
			
			$fields['comment'] = $comment_field;
			
			return $fields;
		}
		
		add_filter( 'comment_form_fields', 'tabligh_move_comment_field_to_bottom' )
?>