<?php 
/*	
*	Pagination File
*	---------------------------------------------------------------------
*	This file return the Pagination to the selected post_type
*	---------------------------------------------------------------------
*/	

	function tabligh_numeric_posts_nav() {
	 
		if( is_singular() )
			return;
	 
		global $wp_query;
 
		/** Stop execution if there's only 1 page */
		if( $wp_query->max_num_pages <= 1 )
			return;
	 
		$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
		$max   = intval( $wp_query->max_num_pages );
 
		/** Add current page to the array */
		if ( $paged >= 1 )
			$links[] = $paged;
	 
		/** Add the pages around the current page to the array */
		if ( $paged >= 3 ) {
			$links[] = $paged - 1;
			$links[] = $paged - 2;
		}
	 
		if ( ( $paged + 2 ) <= $max ) {
			$links[] = $paged + 2;
			$links[] = $paged + 1;
		}
 
		$returnable_html = '';
		
		/** Previous Post Link */
		if ( get_previous_posts_link() )
			$returnable_html .= sprintf( '<li class = "page-item prev brd-rd5">%s</li>' . "\n", get_previous_posts_link('<i class="fas fa-long-arrow-alt-left"></i>') );
	 
		/** Link to first page, plus ellipses if necessary */
		if ( ! in_array( 1, $links ) ) {
			$class = 1 == $paged ? 'active' : '';
	 
			$returnable_html .= sprintf( '<li class = "page-item brd-rd5"><a class = "page-link brd-rd5" href="%s">%s</a></li>' . "\n", esc_url( get_pagenum_link( 1 ) ), '1' );
	 
			if ( ! in_array( 2, $links ) ){
				$returnable_html .= '<li class = "elipses">.......</li>' . "\n";
			}
		}
	 
		
			/** Link to current page, plus 2 pages in either direction if necessary */
			sort( $links );
			foreach ( (array) $links as $link ) {
				$class = $paged == $link ? 'active' : '';
				$returnable_html .= sprintf( '<li class = "page-item brd-rd5"><a class = "page-link brd-rd5 '.$class.'" href="%s">%s</a></li>' . "\n", esc_url( get_pagenum_link( $link ) ), $link );
			}
		
		
		/** Link to last page, plus ellipses if necessary */
		if ( ! in_array( $max, $links ) ) {
			if ( ! in_array( $max - 1, $links ) )
				$returnable_html .= '<li class = "elipses">.......</li>' . "\n";
	 
			$class = $paged == $max ? 'active' : '';
		   $returnable_html .=  sprintf( '<li class = "page-item brd-rd5"><a class = "page-link brd-rd5" href="%s">%s</a></li>' . "\n", esc_url( get_pagenum_link( $max ) ), $max );
		}
		
	 
		/** Next Post Link */
		if ( get_next_posts_link() )
			$returnable_html .= sprintf( '<li class = "page-item next brd-rd5">%s</li>' . "\n", get_next_posts_link('<i class="fas fa-long-arrow-alt-right"></i>') );
	 
		return $returnable_html;
	 
	}
	
	if( !function_exists('tabligh_pagination') ){
		
		function tabligh_pagination($pages = '', $range = 4){		

			/* Don't print empty markup if there's only one page. */
			if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
				return;
			}
			
			global $wp_query;
			
			$big = 999999999;

			$paged = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
						
			$pagenum_link = html_entity_decode( get_pagenum_link() );
			$query_args   = array();
			$url_parts    = explode( '?', $pagenum_link );

			if ( isset( $url_parts[1] ) ) {
				wp_parse_str( $url_parts[1], $query_args );
			}

			$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
			$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

			$format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
			$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

			
			
			/* Set up paginated links.*/
			$links = paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?paged=%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $wp_query->max_num_pages,
				'prev_next' => true,
				'prev_text' => '<i class="fa fa-arrow-left"></i>',
				'next_text' => '<i class="fa fa-arrow-right"></i>',
				'before_page_number' => '',
				'after_page_number'  => ''
			) );

	
			
			html_entity_decode($links);
			
			if ( $links ) :
				return $links;
			endif;

		}
	}
	
	/* Pagination Created For Gallery VC Extension */
	if( !function_exists('pagination_crunch') ){
		
		function pagination_crunch($pg_style = '',$style = '', $pages = '', $range = 4){
		
			$showitems = ($range * 2)+1; 
	
			global $paged;

			if(empty($paged)) $paged = 1;

				if($pages == ''){

					global $wp_query;
				 
					$pages = $wp_query->max_num_pages;

					if(!$pages){
						 
						$pages = 1;
						 
					}
				}   
		 
		 
				if(1 != $pages){
				
					$html = '';
					
					$html .= '
						<div class="pagination-col">
							<nav>
								<ul class="pagination">';
									
									$html .= "<li><a href='".get_pagenum_link($paged - 1)."'>".esc_html__('<','tabligh')."</a></li>";
			 
									for ($i=1; $i <= $pages; $i++){
					 
										if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )) {
						
											 ($paged == $i)? $html .= "<li class=\"active\"><a href='".get_pagenum_link($i)."'>".$i."</a></li>": $html .= "<li><a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a></li>";
										}
									}
			 
									$html .= "<li><a href=\"".get_pagenum_link($paged + 1)."\">".esc_html__('>','tabligh')."</a></li>";
									$html .= "
								</ul>
							</nav>
						</div>";
				
				}else{
				
					$html = "";
				}
			 
				return $html;
		}
	}
?>