<?php get_header();

if ( have_posts() ){ while (have_posts()){ the_post();

	global $post,$EM_Event;
	
	$event_booking_currency = get_post_meta( get_the_ID(), 'event_booking_currency', true );
	$event_booking_price = get_post_meta( get_the_ID(), 'event_booking_price', true );
	$details_title = get_post_meta( get_the_ID(), 'details_title', true );
	$event_detail_list = get_post_meta( get_the_ID(), 'event_detail_list', true );
	$event_speaker_list = get_post_meta( get_the_ID(), 'event_speaker_list', false );
	$event_sidebar_layout = get_post_meta( get_the_ID(), 'event_sidebar_layout', true );
	$event_sidebar_selected = get_post_meta( get_the_ID(), 'event_sidebar_selected', true );

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, esc_html__('Event Details','tabligh')); 
	}
	
	/* Event Timmings */
	if(!empty($EM_Event->start_time)){										  
	  $tabligh_event_time = date("g:i a", strtotime($EM_Event->start_time)) .esc_html(' - ','tabligh').  date("g:i a", strtotime($EM_Event->end_time));
	}
	
	/* Event Location */
	if($EM_Event){
		if(is_object($EM_Event->get_location())){
			if($EM_Event->get_location()->location_name){
				$tabligh_event_location = $EM_Event->get_location()->location_name;
			}
			$location_lat = $EM_Event->get_location()->location_latitude; 
			$location_long = $EM_Event->get_location()->location_longitude; 
		}
	}else{
		$tabligh_event_location = '';
		$location_lat = '';
		$location_long = '';
	}
	
	/* Event Date */
	$tabligh_formatted_event_date =  date(get_option('date_format'),strtotime($EM_Event->start_date)); ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="post-detail-wrap w-100">
					<div class="row">
						<?php /* Left Sidebar */
						if($event_sidebar_layout == 'left'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $event_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
						<div class="<?php if($campaign_sidebar_layout == 'no'){ echo 'col-md-12 col-sm-12 col-lg-12'; }else{ echo 'col-md-12 col-sm-12 col-lg-9'; } ?>">
							<div class="post-detail-inner w-100">
								<div class="post-detail-img mb-0 w-100">
									<?php if(has_post_thumbnail()){ ?> 
										<?php echo get_the_post_thumbnail($post->ID, 'tabligh-event-detail', array( 'class' => 'img-fluid w-100' ));?>
									<?php } /*endif*/ ?>
								</div>
								<div class="event-detail-info d-flex flex-wrap pat-bg gray-layer opc85 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
									<div class="event-detail-info-inner">
										<span class="d-block thm-clr"><i class="fas fa-map-marker-alt"></i><?php echo esc_html($tabligh_event_location); ?></span>
										<h2 class="mb-0"><?php echo get_the_title(); ?></h2>
										<div class="event-detail-price-button d-flex flex-wrap">
											<div class="event-detail-price-button-inner">
												<span class="d-block thm-clr"><i class="far fa-clock"></i><?php echo date("g:i a", strtotime($EM_Event->start_time)); ?> - <?php echo date("g:i a", strtotime($EM_Event->end_time)); ?></span>
												<span class="price d-block"><sup><?php echo esc_html($event_booking_currency); ?></sup><?php echo esc_html($event_booking_price); ?><small><?php echo esc_html('BOOKING PRICE', 'tabligh'); ?></small></span>
											</div>
											<div class="event-detail-price-button-inner">
												<a class="thm-btn bg-color1" href="#buytickets_events"><?php esc_html_e('BUY TICKET','tabligh'); ?><span></span><span></span><span></span><span></span></a>
											</div>
										</div>
									</div>
									<div class="event-detail-info-inner">
										<h4 class="mb-0"><?php echo esc_html($details_title);?></h4>
										<ul class="mb-0 list-unstyled w-100">
											<?php 
											if(is_array($event_detail_list)){ 
												foreach($event_detail_list as $list) { ?>
													<li class="thm-clr"><?php echo esc_html($list); ?></li>
												<?php }
											}?>
										</ul>
									</div>
								</div>
								<div class="post-detail-desc w-100">
									<?php 
									/* Event Content */
									$tabligh_content = str_replace(']]>', ']]&gt;',$EM_Event->post_content); 
									echo wpautop(do_shortcode($tabligh_content)); ?>
								</div>
								<div class="speaker-wrap w-100">
									<h3 class="mb-0"><?php esc_html_e('EVENT SPEAKERS:','tabligh'); ?></h3>
									<div class="speaker-inner res-row w-100">
										<div class="row">
											<?php if(function_exists('tabligh_speakers_list')){ echo tabligh_speakers_list($event_speaker_list[0]); } ?>
										</div>
									</div>
								</div><!-- Speakers Wrap -->
								
								<?php if(function_exists('tabligh_get_event_map')){ ?>
									<div class="event-loc-wrap w-100">
										<?php echo tabligh_get_event_map($location_lat, $location_long); ?>
									</div><!-- Event Location Wrap -->
								<?php } ?>
								
								<div class="event-booking-form-wrap pat-bg gray-layer opc9 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
									<div class="event-booking-form w-100">
										<div id = "buytickets_events" class = "event-booking-form">
											<h3 class="mb-0"><?php esc_html_e('Event Booking Form:','tabligh');?></h3>
											<?php /* Event Booking Form */ 
												if(function_exists('tabligh_booking_form_event_manager')){ echo tabligh_booking_form_event_manager($post->ID); } 
											?>
										</div>
									</div>
								</div><!-- Event Booking Form Wrap -->
							</div>
						</div>
						<?php /* Right Sidebar */
						if($event_sidebar_layout == 'right'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $event_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
					</div>
				</div><!-- Post Detail Wrap -->
			</div>
		</div>
	</section>
	
<?php 
	}
}
get_footer(); ?>