<?php 
get_header();

if (have_posts()){ while (have_posts()){ the_post(); global $post;

	$post_video_url = get_post_meta( get_the_ID(), 'post_video_url', true );
	$post_meta_views = get_post_meta( get_the_ID(), 'post_meta_views', true );
	$post_tags_sharing = get_post_meta( get_the_ID(), 'post_tags_sharing', true );
	$post_secondary_text = get_post_meta( get_the_ID(), 'post_secondary_text', true );
	$post_author_intro = get_post_meta( get_the_ID(), 'post_author_intro', true );
	$author_intro_title = get_post_meta( get_the_ID(), 'author_intro_title', true );
	$post_sidebar_layout = get_post_meta( get_the_ID(), 'post_sidebar_layout', true );
	$post_sidebar_selected = get_post_meta( get_the_ID(), 'post_sidebar_selected', true );
	
	$archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_day   = get_the_time('d'); 
	
	$user = wp_get_current_user($post->ID);
	$avatar_url = get_avatar_url($user->ID, array("size"=>32));
	$avatar_url_large = get_avatar_url($user->ID, array("size"=>170));
	
	/* Get Comment Count */
	$comment_count = wp_count_comments( $post->ID );
	$comment_count = $comment_count->total_comments;
	
	/* it sets the post view */
	if(function_exists('tabligh_set_post_view')){ tabligh_set_post_view(); }

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, get_the_title()); 
	} ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="post-detail-wrap w-100">
					<div class="row">
						<?php /* Left Sidebar */
						if($post_sidebar_layout == 'left'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $post_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
						<div class="<?php if($post_sidebar_layout == 'no'){ echo 'col-md-12 col-sm-12 col-lg-12'; }else{ echo 'col-md-12 col-sm-12 col-lg-9'; } ?>">
							<div class="post-detail-inner w-100">
								<?php if(has_post_thumbnail()){ ?> 
								<div class="post-detail-img w-100">
									<?php echo get_the_post_thumbnail($post->ID, 'tabligh-post-detail', array( 'class' => 'img-fluid w-100' ));?>
								</div>
								<?php } /*endif*/ ?>
								<div class="post-detail-info position-relative w-100">
									<div class="post-info2-inner text-center">
										<div class="post-date2">
											<span class="d-block"><a href = "<?php echo get_day_link( $archive_year, $archive_month, $archive_day);?>"><?php echo get_the_date('d'); ?></a></span>
											<i class="d-block thm-bg"><a href = "<?php echo get_day_link( $archive_year, $archive_month, $archive_day);?>"><?php echo get_the_date('M Y'); ?></a></i>
										</div>
										<div class="post-meta4 w-100">
											<?php if(function_exists('tabligh_get_post_view')){ ?>
												<span class="d-block"><i class="far fa-eye"></i><?php echo tabligh_get_post_view(); ?></span>
											<?php } ?>
											<?php if(function_exists('get_simple_likes_button')){ ?><span class="d-block"><?php echo get_simple_likes_button( $post->ID ); ?></span><?php } ?>
											<span class="d-block"><i class="far fa-comment"></i><?php echo esc_html($comment_count); ?></span>
										</div>
									</div>
									<ul class="post-meta2 d-inline-flex flex-wrap align-items-center mb-0 list-unstyled">
										<li class="thm-clr"><i class="far fa-folder-open"></i>
										<?php
											/* Post Categories */
											$postcats = get_the_category();
											$all_cats = array();
											
											if ($postcats){ ?>
													<?php foreach($postcats as $cat) {
															$all_cats[] = '<a class="brd-rd5" href = "'.esc_url(get_tag_link($cat->term_id)).'">'.esc_html($cat->name).'</a>';
													}
													
													$echo_cats = implode(', ', $all_cats);
													echo html_entity_decode($echo_cats);
											} ?>
										</li>
										<li class="thm-clr"><i class="far fa-edit"></i><?php esc_html_e('By:','tabligh'); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></a></li>
									</ul>
									<?php /* The Content */
										the_content(); 		
										wp_link_pages( array(
											'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'tabligh' ) . '</span>',
											'after'       => '</div>',
											'link_before' => '',
											'link_after'  => '',
											'pagelink'    => '<span>%</span>',
											'separator'   => '',
										) );
									?>
								</div>
								<?php if($post_secondary_text){ ?>
									<div class="post-detail-desc w-100">
										<?php echo wpautop(do_shortcode($post_secondary_text)); ?>
									</div>
								<?php } ?>								
								<?php
								/* Post Tags */
								$posttags = get_the_tags();
								$all_tags = array();
								if ($posttags || $post_tags_sharing == 'display'){ ?>
									<div class="share-tags-wrap d-flex flex-wrap w-100">
										<?php if($post_tags_sharing == 'display'){ ?>
											<div class="share-links d-inline-flex">
												<span class="d-inline-block"><?php esc_html_e('Share This: ','tabligh');?></span>
												<div class="social-links4 v2 text-center d-inline-flex">
													<?php if(function_exists('tabligh_post_social_shares')){ echo tabligh_post_social_shares($post->ID); } ?>
												</div>
											</div>
										<?php } 
										if($posttags){ ?>
											<div class="tags-links d-inline-flex">											
												<span class="d-inline-block"><?php esc_html_e('Tags: ','tabligh');?></span>
												<?php 
												foreach($posttags as $tag) {
														$all_tags[] = '<a href = "'.esc_url(get_tag_link($tag->term_id)).'">'.esc_html($tag->name).'</a>';
												}
												
												$echo_tags = implode(', ', $all_tags);
												echo html_entity_decode($echo_tags);
												echo '
											</div>';
										} ?>
									<?php echo '
									</div>';
								} ?>
								</div><!-- Share & Tags Wrap -->
								<?php if($post_author_intro == 'false'){ ?>
										<div class="author-box-wrap w-100">
											<?php if($author_intro_title){ ?><h3 class="mb-0"><?php echo esc_html($author_intro_title); ?></h3><?php } ?>
											<div class="author-box d-flex flex-wrap pat-bg gray-layer opc9 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
												<div class="author-img">
													<img class="img-fluid w-100" src="<?php echo esc_url($avatar_url_large); ?>" alt="<?php esc_attr__('Author Image','tabligh'); ?>">
												</div>
												<div class="author-info">
													<h4 class="mb-0"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></h4> 
													<?php if(!empty(get_the_author_meta('designation'))) { ?>	
														<small class="thm-clr">(<?php echo esc_html(get_the_author_meta('designation')); ?>)</small> 
													<?php } ?>
													<p class="mb-0"><?php echo nl2br(get_the_author_meta('description')); ?></p>
													<div class="author-social d-inline-flex">
														<span class="d-inline-block"><?php echo esc_html('STAY CONNECTED:','tabligh'); ?></span>
														<div class="author-social-inner d-inline-flex">
														<?php if(!empty(get_the_author_meta('twitter'))) { ?>
															<a href="<?php echo esc_url(get_the_author_meta('twitter')); ?>" title="<?php esc_attr__('Twitter','tabligh'); ?>" target="_blank"><i class="thm-clr fab fa-twitter"></i></a>
														<?php } ?>
														<?php if(!empty(get_the_author_meta('facebook'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('facebook')); ?>" title="<?php esc_attr__('Faceboook','tabligh'); ?>" target="_blank"><i class="thm-clr fab fa-facebook-f"></i></a>
														<?php } ?>	
														<?php if(!empty(get_the_author_meta('linkedin'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('linkedin')); ?>" title="<?php esc_attr__('LinkedIn','tabligh'); ?>" target="_blank"><i class="thm-clr fab fa-linkedin-in"></i></a>
														<?php } ?>	
														</div>
													</div>
												</div>
											</div>
										</div><!-- Author Box Wrap -->
								<?php } ?>
								
								<?php /* Comments list Template */ if ( comments_open() || get_comments_number() ) : comments_template(); endif; ?>
								<?php if (comments_open()){ ?> 
								<div class = "comment-reply w-100">
									<?php /* comment Form */
									$post_commenter = wp_get_current_commenter();
									$req = get_option( 'require_name_email' );
									$aria_req = ( $req ? " aria-required='true'" : '' );
									if(function_exists('tabligh_comment_form_temp')){ ?>
										<div class = "comment-reply w-100"><?php echo tabligh_comment_form_temp($post_commenter, $req, $aria_req ); ?></div>
									<?php 
									}
									?>
								</div>
								<?php } ?>
							</div>
							<?php /* Left Sidebar */
							if($post_sidebar_layout == 'right'){ ?>
								<div class="col-md-6 col-sm-6 col-lg-3">
									<aside class="sidebar w-100">
										<?php dynamic_sidebar( $post_sidebar_selected ); ?>
									</aside>
								</div>
							<?php } /*endif */ ?>
						</div>
					</div>
				</div><!-- Post Detail Wrap -->
			</div>
		</div>
	</section>
	
	<?php 
	}/*end of while statement*/

} /*end of if statement*/
get_footer(); ?>